/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityDataCard
extends ItemBaseCyclic {
    private static final String ENTITY_DATA = "entity_data";
    private static final String ENTITY_KEY = "entity_key";

    public EntityDataCard(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            TranslatableComponent t = new TranslatableComponent(stack.m_41783_().m_128461_(ENTITY_KEY));
            t.m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)t);
        } else {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6047_()) {
            CompoundTag atag = player.m_21120_(hand).m_41784_();
            atag.m_128365_(ENTITY_DATA, (Tag)player.getPersistentData());
            atag.m_128359_(ENTITY_KEY, "player");
        }
        return super.m_7203_(level, player, hand);
    }

    public InteractionResult m_6880_(ItemStack stack, Player playerIn, LivingEntity target, InteractionHand hand) {
        playerIn.m_6674_(hand);
        CompoundTag atag = stack.m_41784_();
        atag.m_128365_(ENTITY_DATA, (Tag)target.getPersistentData());
        if (target instanceof Player) {
            atag.m_128359_(ENTITY_KEY, "player");
        } else {
            String key = EntityType.m_20613_((EntityType)target.m_6095_()).toString();
            atag.m_128359_(ENTITY_KEY, key);
        }
        stack.m_41751_(atag);
        return super.m_6880_(stack, playerIn, target, hand);
    }

    public static boolean matchesEntity(Entity etar, ItemStack stack) {
        if (etar == null || !EntityDataCard.hasEntity(stack)) {
            return false;
        }
        EntityType<?> type = EntityDataCard.getEntityType(stack);
        return type == etar.m_6095_();
    }

    private static EntityType<?> getEntityType(ItemStack stack) {
        if (stack.m_41720_() instanceof EntityDataCard) {
            String key = stack.m_41783_().m_128461_(ENTITY_KEY);
            return EntityType.m_20632_((String)key).orElse(null);
        }
        return null;
    }

    public static boolean hasEntity(ItemStack stack) {
        if (stack.m_41720_() instanceof EntityDataCard) {
            return stack.m_41782_() && stack.m_41783_().m_128441_(ENTITY_KEY);
        }
        return false;
    }
}

